﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace RepairDesktopIcon
{
    public partial class FormMain : Form
    {
        public FormMain()
        {
            InitializeComponent();
        }

        private void btn_repair_Click(object sender, EventArgs e)
        {
            try
            {
                //杀掉资源管理器进程
                ExplorerCmdControl(true);

                List<string> paths = GetIconCachePath();

                if (paths == null)
                {
                    throw new Exception("获取IconCache.db失败！");
                }
                foreach (string item in paths)
                {
                    try
                    {
                        if (File.Exists(item))
                        {
                            //删除缓存
                            File.Delete(item);
                        }
                    }
                    catch { }
                }

                MessageBox.Show("修复完成！","提示",MessageBoxButtons.OK,MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                MessageBox.Show("修复失败，错误："+ex.Message, "错误", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                ExplorerCmdControl(false);  //启动资源管理器
            }
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            lab_name.Text = Environment.UserName;
        }

        private List<string> GetIconCachePath()
        {
            try
            {
                List<string> allCacheDbFile = new List<string>();
                string userOwnPath = System.Environment.GetFolderPath(Environment.SpecialFolder.Personal);
                Directory.SetCurrentDirectory(Directory.GetParent(userOwnPath).FullName);
                allCacheDbFile.Add(Directory.GetCurrentDirectory() + @"\AppData\Local\IconCache.db");

                string explorerCachePath = Directory.GetCurrentDirectory() + @"\AppData\Local\Microsoft\Windows\Explorer";
                DirectoryInfo root = new DirectoryInfo(explorerCachePath);
                FileInfo[] files = root.GetFiles();
                foreach(var item in files)
                {
                    if (Path.GetExtension(item.Name) == ".db") {
                        allCacheDbFile.Add(item.FullName);
                    }
                }
                return allCacheDbFile;
            }
            catch
            {
                return null;
            }
        }

        private string ExplorerCmdControl(bool isKill)
        {
            try
            {
                string str = string.Empty;
                //string str = Console.ReadLine();
                if (isKill)
                {
                    str = @"taskkill /f /im explorer.exe";
                }
                else
                {
                    str = @"C:\Windows\explorer.exe";
                }

                Process p = new Process();
                p.StartInfo.FileName = "cmd";
                p.StartInfo.UseShellExecute = false;                 //是否使用操作系统shell启动
                p.StartInfo.RedirectStandardInput = true;            //接受来自调用程序的输入信息
                p.StartInfo.RedirectStandardOutput = true;           //由调用程序获取输出信息
                p.StartInfo.RedirectStandardError = true;            //重定向标准错误输出
                p.StartInfo.CreateNoWindow = true;                   //不显示程序窗口
                p.Start();                                           //启动程序
                                                                     //向cmd窗口发送输入信息
                p.StandardInput.WriteLine(str + "&exit");
                //p.StandardInput.WriteLine(str);
                p.StandardInput.AutoFlush = true;
                //p.StandardInput.WriteLine("exit");
                //向标准输入写入要执行的命令。这里使用&是批处理命令的符号，表示前面一个命令不管是否执行成功都执行后面(exit)命令，如果不执行exit命令，后面调用ReadToEnd()方法会假死
                //同类的符号还有&&和||前者表示必须前一个命令执行成功才会执行后面的命令，后者表示必须前一个命令执行失败才会执行后面的命令

                //获取cmd窗口的输出信息
                string output = p.StandardOutput.ReadToEnd();
                p.WaitForExit();//等待程序执行完退出进程
                p.Close();
                return output;
            }
            catch(Exception ex)
            {
                if (isKill)
                {
                    throw new Exception("关闭Explorer失败，请重试！错误："+ex.Message);
                }
                else
                {
                    throw new Exception("关闭Explorer失败，请重试！错误：" + ex.Message);
                }
            }
        }

        
    }
}
