﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using AspNetCoreMvc.Models;
using AspNetCoreMvc.Models.Entity;

namespace AspNetCoreMvc.Controllers
{
    public class HomeController : Controller
    {
        private readonly CoreDbContent _db;

        public HomeController(CoreDbContent content)
        {
            _db = content;
        }

        public IActionResult Index()
        {
            try
            {
                using (_db)
                {
                    List<Students> students = _db.Students.ToList();
                    if(students!=null && students.Count > 0)
                    {
                        ViewBag.Students = students;
                    }
                    else
                    {
                        ViewBag.Students = new List<Students>();
                    }
                    return View();
                }
            }
            catch(Exception ex)
            {
                throw new Exception($"获取学生数据==信息失败，{ex.Message}");
            }
        }

        public IActionResult Privacy()
        {
            return View();
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
