﻿using AspNetCoreMvc.Models.Entity;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace AspNetCoreMvc.Models
{
    public class DbDataInitializer
    {
        public static void Initialize(CoreDbContent context)
        {
            //如果没有数据库，那么新建数据库
            context.Database.EnsureCreated();

            if (context.Students.Count() > 0)
            {
                return;
            }
            Students[] stus = new Students[]{
                new Students()
                {
                    Name = "小明",
                    Sex = "男",
                    Phone = "123456"
                },
                new Students()
                {
                    Name = "小红",
                    Sex = "女",
                    Phone = "456789"
                }
            };
            context.Students.AddRange(stus);
            if (context.SaveChanges() == 0)
            {
                throw new Exception("写入默认数据失败。");
            }
        }
    }
}
