﻿using Newtonsoft.Json;
using OnceMi.Framework.Util.Json;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text.Encodings.Web;
using System.Text.Json;
using System.Text.Unicode;
using System.Threading;

namespace SerializeTest
{
    internal class Program
    {
        private static readonly SystemLog testModel = new SystemLog()
        {
            Id = 1,
            LogType = "Error",
            Describe = "这个是描述，这个是描述，这个是描述，这个是描述，这个是描述",
            Stack = "",
            CreateTime = DateTime.Parse("2022-07-10"),
            Guid = Guid.NewGuid(),
            ExtFileds = new Dictionary<string, object>()
            {
                { "A", DateTime.Parse("2022-07-10")},
                { "B", "AAAAAA"},
            }
        };

        private static int testCount = 100000;
        private static int avgCount = 20;

        static void Main(string[] args)
        {
            Thread.Sleep(1000);
            Console.WriteLine("开始测试...");

            string baseTip = $"测试{testCount}次序列化与反序列化耗时（取{avgCount}次平均值）";
            Console.WriteLine("开始二进制序列化测试...");
            Console.WriteLine($"二进制序列化{baseTip}：{TestBinarySerialize()}ms\n");

            Console.WriteLine("开始System.Text.Json序列化测试...");
            Console.WriteLine($"System.Text.Json序列化{baseTip}：{TestSystemTextJsonSerialize()}ms\n");

            Console.WriteLine("开始System.Text.Json Utf8Bytes序列化测试...");
            Console.WriteLine($"System.Text.Json Utf8Bytes列化{baseTip}：{TestSystemTextJsonBinarySerialize()}ms\n");

            Console.WriteLine("开始Newtonsoft.Json序列化测试...");
            Console.WriteLine($"Newtonsoft.Json序列化{baseTip}：{TestNewtonsoftJsonSerialize()}ms\n");

            Console.ReadKey();
        }

        static long TestBinarySerialize()
        {
            try
            {
                BinaryFormatter serializer = new BinaryFormatter();
                long[] testResult = new long[avgCount];

                for (int i = 0; i < avgCount; i++)
                {
                    Stopwatch sw = new Stopwatch();
                    sw.Start();

                    for (int j = 0; j < testCount; j++)
                    {
                        using (MemoryStream memStream = new MemoryStream())
                        {
                            serializer.Serialize(memStream, testModel);
                            memStream.Position = 0;
                            _ = serializer.Deserialize(memStream) as SystemLog;
                        }
                    }

                    sw.Stop();
                    testResult[i] = sw.ElapsedMilliseconds;
                }
                return testResult.Sum() / avgCount;
            }
            finally
            {
                GC.Collect();
            }
        }

        static long TestSystemTextJsonSerialize()
        {
            try
            {
                long[] testResult = new long[avgCount];

                for (int i = 0; i < avgCount; i++)
                {
                    Stopwatch sw = new Stopwatch();
                    sw.Start();

                    for (int j = 0; j < testCount; j++)
                    {
                        string json = JsonUtil.SerializeToString(testModel);
                        _ = JsonUtil.DeserializeStringToObject<SystemLog>(json);
                    }
                    sw.Stop();
                    testResult[i] = sw.ElapsedMilliseconds;
                }
                return testResult.Sum() / avgCount;
            }
            finally
            {
                GC.Collect();
            }
        }

        static long TestSystemTextJsonBinarySerialize()
        {
            try
            {
                long[] testResult = new long[avgCount];

                for (int i = 0; i < avgCount; i++)
                {
                    Stopwatch sw = new Stopwatch();
                    sw.Start();

                    for (int j = 0; j < testCount; j++)
                    {
                        byte[] bytes = JsonUtil.SerializeToByte(testModel);
                        _ = JsonUtil.DeserializeByteToObject<SystemLog>(bytes);
                    }
                    sw.Stop();
                    testResult[i] = sw.ElapsedMilliseconds;
                }
                return testResult.Sum() / avgCount;
            }
            finally
            {
                GC.Collect();
            }
        }

        static long TestNewtonsoftJsonSerialize()
        {
            try
            {
                long[] testResult = new long[avgCount];

                for (int i = 0; i < avgCount; i++)
                {
                    Stopwatch sw = new Stopwatch();
                    sw.Start();

                    for (int j = 0; j < testCount; j++)
                    {
                        string json = JsonConvert.SerializeObject(testModel);
                        _ = JsonConvert.DeserializeObject<SystemLog>(json);
                    }
                    sw.Stop();
                    testResult[i] = sw.ElapsedMilliseconds;
                }
                return testResult.Sum() / avgCount;
            }
            finally
            {
                GC.Collect();
            }
        }
    }

    [Serializable]
    public class SystemLog
    {
        public int Id { get; set; }

        public string LogType { get; set; }

        public string Describe { get; set; }

        public string Localtion { get; set; }

        public string Stack { get; set; }

        public DateTime CreateTime { get; set; }

        public Guid Guid { get; set; }

        public Dictionary<string, object> ExtFileds { get; set; }
    }
}